/*
 * Decompiled with CFR 0.152.
 */
package menuexample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import menuexample.MenuExampleMouseAdapter;

public class MenuExample
extends JFrame {
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel status = new JLabel(" ");

    public MenuExample() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(178, 178, 178));
        this.contentPane.setLayout(this.borderLayout1);
        this.status.setBorder(border);
        this.status.setOpaque(true);
        this.contentPane.add((Component)this.status, "South");
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle("Menu example");
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenu menuView = new JMenu("View");
        menuFile.addMouseListener(new MenuExampleMouseAdapter("Menu file", " ", this.status));
        menuView.addMouseListener(new MenuExampleMouseAdapter("Menu view", " ", this.status));
        JMenuItem item1 = new JMenuItem("New");
        item1.addMouseListener(new MenuExampleMouseAdapter("New file", " ", this.status));
        JMenuItem item2 = new JMenuItem("Open");
        item2.addMouseListener(new MenuExampleMouseAdapter("Open file", " ", this.status));
        JMenuItem item3 = new JMenuItem("Save");
        item3.addMouseListener(new MenuExampleMouseAdapter("Save file", " ", this.status));
        JMenuItem item4 = new JMenuItem("Save as..");
        item4.addMouseListener(new MenuExampleMouseAdapter("Save file as..", " ", this.status));
        JMenuItem item5 = new JMenuItem("Close");
        item5.addMouseListener(new MenuExampleMouseAdapter("Close file", " ", this.status));
        JMenuItem item6 = new JMenuItem("Exit");
        item6.addMouseListener(new MenuExampleMouseAdapter("Exit prorgamm", " ", this.status));
        menuFile.add(item1);
        menuFile.add(item2);
        menuFile.addSeparator();
        menuFile.add(item3);
        menuFile.add(item4);
        menuFile.addSeparator();
        menuFile.add(item5);
        menuFile.addSeparator();
        menuFile.add(item6);
        JMenuItem itemv1 = new JMenuItem("BGColor");
        itemv1.addMouseListener(new MenuExampleMouseAdapter("Change background color", " ", this.status));
        itemv1.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        itemv1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int r = (int)(Math.random() * (double)255);
                int g = (int)(Math.random() * (double)255);
                int b = (int)(Math.random() * (double)255);
                MenuExample.this.contentPane.setBackground(new Color(r, g, b));
            }
        });
        JMenu menuUI = new JMenu("Look & Feel");
        menuUI.addMouseListener(new MenuExampleMouseAdapter("Change Look & Feel", " ", this.status));
        JRadioButtonMenuItem itemui1 = new JRadioButtonMenuItem("Windows Look & Feel");
        JRadioButtonMenuItem itemui2 = new JRadioButtonMenuItem("Metal Look & Feel");
        JRadioButtonMenuItem itemui3 = new JRadioButtonMenuItem("Motif Look & Feel");
        ButtonGroup bg = new ButtonGroup();
        bg.add(itemui1);
        bg.add(itemui2);
        bg.add(itemui3);
        itemui1.addMouseListener(new MenuExampleMouseAdapter("Windows Look & Feel", " ", this.status));
        itemui2.addMouseListener(new MenuExampleMouseAdapter("Metal Look & Feel", " ", this.status));
        itemui3.addMouseListener(new MenuExampleMouseAdapter("Motif Look & Feel", " ", this.status));
        itemui1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuExample.this.setLookAndFeel(1);
            }
        });
        itemui2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuExample.this.setLookAndFeel(2);
            }
        });
        itemui3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuExample.this.setLookAndFeel(3);
            }
        });
        itemui2.setSelected(true);
        menuUI.add(itemui1);
        menuUI.add(itemui2);
        menuUI.add(itemui3);
        itemv1.addMouseListener(new MenuExampleMouseAdapter("Change background color", " ", this.status));
        itemv1.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuView.add(itemv1);
        menuView.add(menuUI);
        JMenu menuThread = new JMenu("Thread");
        menuThread.addMouseListener(new MenuExampleMouseAdapter("Thread", " ", this.status));
        JMenuItem itemT1 = new JMenuItem("Add");
        JMenuItem itemT2 = new JMenuItem("Run");
        JMenuItem itemT3 = new JMenuItem("Pause");
        JMenuItem itemT4 = new JMenuItem("Delete");
        itemT1.addMouseListener(new MenuExampleMouseAdapter("Add thread", " ", this.status));
        itemT2.addMouseListener(new MenuExampleMouseAdapter("Run thread", " ", this.status));
        itemT3.addMouseListener(new MenuExampleMouseAdapter("Pause thread", " ", this.status));
        itemT4.addMouseListener(new MenuExampleMouseAdapter("Delete thread", " ", this.status));
        ImageIcon image1 = new ImageIcon(this.getToolkit().createImage("images/add.gif"));
        ImageIcon image2 = new ImageIcon(this.getToolkit().createImage("images/play.gif"));
        ImageIcon image3 = new ImageIcon(this.getToolkit().createImage("images/pause.gif"));
        ImageIcon image4 = new ImageIcon(this.getToolkit().createImage("images/delete.gif"));
        itemT1.setIcon(image1);
        itemT2.setIcon(image2);
        itemT3.setIcon(image3);
        itemT4.setIcon(image4);
        menuThread.add(itemT1);
        menuThread.addSeparator();
        menuThread.add(itemT2);
        menuThread.add(itemT3);
        menuThread.addSeparator();
        menuThread.add(itemT4);
        menuBar.add(menuFile);
        menuBar.add(menuView);
        menuBar.add(menuThread);
        this.setJMenuBar(menuBar);
    }

    public void setLookAndFeel(int type) {
        String laf = "javax.swing.plaf.metal.MetalLookAndFeel";
        switch (type) {
            case 1: {
                laf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                break;
            }
            case 2: {
                laf = "javax.swing.plaf.metal.MetalLookAndFeel";
                break;
            }
            case 3: {
                laf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
        }
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }
}

