package filescheck;
/**
 * Title:      URL.
 * Description:       URL,       .
 * Copyright: Yura Ladik  Copyright (c) 2002
 * Company:
 * @author Yura Ladik
 * @version 0.1
 */
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.io.*;
public class FilesCheckConnection extends Thread
{
 private FilesCheck filesCheck;//  
 //    
 public static int STATUS_ERROR = -1; //  
 public static int STATUS_NOSTARTED = 0; //   
 public static int STATUS_DOWLOADING = 1; //  
 public static int STATUS_DOWLOADING_FINISH = 2; //   
 public static int STATUS_DOWLOADING_PAUSE = 3; //   
 public static int STATUS_DELETED = 4; //  
 public static int STATUS_STARTING = 5; //   

 //    URL  
 private String error = "";
 private int status = 0;
 private String fileName = "";
 private long size = 0;
 private long completed = 0;
 private byte percent = 0;
 private Date startTime;
 private Date endTime;
 private URL fileURL;
 private boolean startThread;
 private boolean stopThread;

 /**
  *  FilesCheckConnection
  *
  * @param  
  */
 public FilesCheckConnection(FilesCheck filesCheck)
 {
  this.filesCheck = filesCheck;
 }
  /**
   *  FilesCheckConnection
   */
 public FilesCheckConnection(FilesCheck filesCheck, String fileURL)
 {
  this.filesCheck = filesCheck;
  try
  {//      URL.
   this.fileURL = new URL(fileURL);
   synchronized(filesCheck.statusBar)
   {
    filesCheck.statusBar.setText("Adding URL successful");
    status=STATUS_STARTING; //    
   }
  }
  catch(Exception e)
  {
   synchronized(filesCheck.statusBar)
   {
    filesCheck.statusBar.setText("Error adding URL:"+e);
   }
   status = STATUS_ERROR; //      
   error= ""+e;
   filesCheck.updadeInfo(this); //       
  }
 }
 public void run()
 {
  if(fileURL != null)
  {
   filesCheck.updadeInfo(this); //       
   startThread=true; //  
   URLConnection connection;
   try
   {
    connection = fileURL.openConnection(); //  
    fileName = fileURL.getFile();
    size = connection.getContentLength(); //  
    startTime = new Date(); //   ()
    synchronized(filesCheck.statusBar)
    {
     filesCheck.statusBar.setText(""+startTime.toString());
    }
    filesCheck.updadeInfo(this); //       
   }
   catch(Exception e)
   {
    status = STATUS_ERROR; //  
    error = ""+e;
    filesCheck.saveToReport(this); //       
   }
   try
   {
    InputStream in = fileURL.openConnection().getInputStream(); //  
    status = STATUS_DOWLOADING; //  
    int sizef = (int)size;
    int chars_read = 0;
    byte[] data = new byte[sizef];
    filesCheck.updadeInfo(this); //       
    //     
    Date dd=new Date();
    long ccc=dd.getTime();

    while(completed != size)
    {
     synchronized(this)
     {
      while (!startThread)  wait(100); // 
     }

     data[(int)completed] = (byte)in.read(); //    
     completed++; //  
     percent=(byte)(completed/(size/100)); //  
     if(ccc>dd.getTime()+1)
     {
     ccc=dd.getTime();
     filesCheck.updadeInfo(this); //       
     }
    }
    in.close(); //  
    endTime = new Date(); //   ( )
    status = STATUS_DOWLOADING_FINISH; //   
    filesCheck.updadeInfo(this); //       
    filesCheck.saveToReport(this); //        
   }
   catch(Exception e)
   {
    status = STATUS_ERROR;
    error = ""+e;
    filesCheck.saveToReport(this); //       
   }
  }
  stopThread=true; //  
 }

 /**
  *    
  */
 public int getStatus()
 {
  return status;
 }

 /**
 *     
 */
 public String getStatusString()
 {
  switch(getStatus())
  {
   case -1: return "STATUS_ERROR";
   case 0: return "STATUS_NOSTARTED";
   case 1: return "STATUS_DOWLOADING";
   case 2: return "STATUS_DOWLOADING_FINISH";
   case 3: return "STATUS_DOWLOADING_PAUSE";
   case 4: return "STATUS_DELETED";
   case 5: return "STATUS_STARTING";
   default: return "STATUS_STARTING";
  }
 }

 /**
 *   
 */
 public String getFileName()
 {
  return fileName;
 }

 /**
 *   
 */
 public long getSize()
 {
  return size;
 }

 /**
 *     
 */
 public long getCopmleted()
 {
  return completed;
 }

  /**
 *      
 */
 public byte getPercent()
 {
  return percent;
 }

 /**
 *    
 */
 public Date getStartTime()
 {
  return startTime;
 }

 /**
 *    
 */
 public Date getEndDate()
 {
  return endTime;
 }

 /**
 *  URL
 */
 public String getFileURL()
 {
  return  fileURL.toExternalForm();
 }

 /**
 *  
 */
 public String getError()
 {
  return  error;
 }

 /**
 *     
 */
 public void setStartThread(boolean start)
 {
  startThread =  start;
  if(start)
  {
   status = STATUS_DOWLOADING; //   
   currentThread().setPriority(Thread.MIN_PRIORITY); //   
  }
  else
  {
   status = STATUS_DOWLOADING_PAUSE; //   
   currentThread().setPriority(Thread.NORM_PRIORITY);//  
  }
  filesCheck.updadeInfo(this); //       
 }

 /**
 *           
 */
 public boolean isStartThread()
 {
  return startThread;
 }

 /**
 *     
 */
 public boolean isStopThread()
 {
  return stopThread;
 }
}