package filescheck;
/**
 * Title:   GUI.
 * Description:
 * Copyright: Yura Ladik  Copyright (c) 2002
 * Company:
 * @author Yura Ladik
 * @version 0.1
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.beans.*;
import java.util.Vector;
import javax.swing.table.*;
import javax.swing.text.*;
import java.io.*;

public class FilesCheck extends JFrame
{
 Vector arrThread = new Vector(); //   FilesCheckConnection
 //    
 JPanel contentPane;
 BorderLayout borderLayout1 = new BorderLayout();
 JToolBar toolBar = new JToolBar();
 JScrollPane jScrollPane1 = new JScrollPane();
 JLabel statusBar = new JLabel(" No URL");
 String[] columnNames = {"Status", "File name", "Size","Completed","Percent","Start Time","End Time","URL"};
 JTable jTable =new JTable(new DefaultTableModel(columnNames,0));
 JTextArea jTextArea1 = new JTextArea();
 JTextField stringURL = new JTextField();
 JButton button1 = new JButton();
 JButton button2 = new JButton();
 JButton button3 = new JButton();
 JButton button4 = new JButton();
 JButton button5 = new JButton();
 /**Construct the frame*/
 public FilesCheck()
 {
  enableEvents(AWTEvent.WINDOW_EVENT_MASK);
  try
  {
   jbInit();
  }
  catch(Exception e)
  {
   e.printStackTrace();
  }
 }
 /**Component initialization*/
 private void jbInit() throws Exception
 {
  contentPane = (JPanel) this.getContentPane();
  contentPane.setLayout(borderLayout1);
  this.setSize(new Dimension(640,480));
  this.setTitle("FilesCheck");
  //  
  ImageIcon image1 = new ImageIcon(getToolkit().createImage("images/add.gif"));
  ImageIcon image2 = new ImageIcon(getToolkit().createImage("images/play.gif"));
  ImageIcon image3 = new ImageIcon(getToolkit().createImage("images/pause.gif"));
  ImageIcon image4 = new ImageIcon(getToolkit().createImage("images/delete.gif"));
  ImageIcon image5 = new ImageIcon(getToolkit().createImage("images/report.gif"));

  //   
  jTable.addMouseListener(new java.awt.event.MouseAdapter()
  {
   public void mouseClicked(MouseEvent e)
   {
    jTable_mouseClicked(e);
   }
  });
  button1.addActionListener(new java.awt.event.ActionListener()
  {
   public void actionPerformed(ActionEvent e)
   {
    button1_actionPerformed(e);
   }
  });
  button2.addActionListener(new java.awt.event.ActionListener()
  {
   public void actionPerformed(ActionEvent e)
   {
    button2_actionPerformed(e);
   }
  });
  button3.addActionListener(new java.awt.event.ActionListener()
  {
   public void actionPerformed(ActionEvent e)
   {
    button3_actionPerformed(e);
   }
  });
  button4.addActionListener(new java.awt.event.ActionListener()
  {
   public void actionPerformed(ActionEvent e)
   {
    button4_actionPerformed(e);
   }
  });
  button5.addActionListener(new java.awt.event.ActionListener()
  {
   public void actionPerformed(ActionEvent e)
   {
    button5_actionPerformed(e);
   }
  });
  contentPane.add(toolBar, BorderLayout.NORTH);
  contentPane.add(statusBar, BorderLayout.SOUTH);
  contentPane.add(jScrollPane1, BorderLayout.CENTER);
  jScrollPane1.setBackground(Color.white);
  button1.setIcon(image1);
  button1.setToolTipText("Add");
  button2.setIcon(image2);
  button2.setToolTipText("Start");
  button3.setIcon(image3);
  button3.setToolTipText("Pause");
  button4.setIcon(image4);
  button4.setToolTipText("Delete");
  button5.setIcon(image5);
  button5.setToolTipText("View report file");
  toolBar.add(stringURL);
  toolBar.add(button1);
  toolBar.add(button2);
  toolBar.add(button3);
  toolBar.add(button4);
  toolBar.add(button5);
  jTable.setSelectionMode(0);
  jTable.setEnabled(false);
  button2.setEnabled(false);
  button3.setEnabled(false);
  button4.setEnabled(false);
  jScrollPane1.getViewport().add(jTable);
  readReportFile(); //   
 }
 /**Overridden so we can exit when window is closed*/
 protected void processWindowEvent(WindowEvent e)
 {
  super.processWindowEvent(e);
  if (e.getID() == WindowEvent.WINDOW_CLOSING)
  {
   FilesCheckConnection fcc;
   for(int i = 0; i < arrThread.size(); i++)
   {
    fcc=(FilesCheckConnection)arrThread.elementAt(i);
    fcc=null;
   }
   System.exit(0);
  }
 }
 /**     .       .*/
 void jTable_mouseClicked(MouseEvent e)
 {
  jTable.addRowSelectionInterval(jTable.rowAtPoint(e.getPoint()),jTable.rowAtPoint(e.getPoint()));
  if(jTable.getSelectedRow() > -1)
  {
   button4.setEnabled(true);
   FilesCheckConnection fcc = (FilesCheckConnection)arrThread.elementAt(jTable.getSelectedRow());
   //   
   if(fcc.isStopThread())
   {
    button3.setEnabled(false);
    button3.setEnabled(false);
   }
   else
   {
    if(fcc.isStartThread())
    {
     button2.setEnabled(false);
     button3.setEnabled(true);
    }
    else
    {
     button2.setEnabled(true);
     button3.setEnabled(false);
    }
   }
  }
 }
 /**
  *     button1 (Add).  
  *        URL.  .
  */
 void button1_actionPerformed(ActionEvent e)
 {
  try
  {
   TableModel tm = new DefaultTableModel(columnNames,arrThread.size()+1);
   jTable.setModel(tm);
   FilesCheckConnection fcc = new FilesCheckConnection(this,stringURL.getText());
   arrThread.add(fcc);
   fcc.start();
   updadeTable(); //  
  }
  catch(Exception ee)
  {
   System.out.println("Error: "+ee);
  }
 }
 /**
  *     button2 (Start).  .
  */
 void button2_actionPerformed(ActionEvent e)
 {
  if(jTable.getSelectedRow() > -1)
  {
   FilesCheckConnection fcc = (FilesCheckConnection)arrThread.elementAt(jTable.getSelectedRow());
   fcc.setStartThread(true); // .
   //   
   button2.setEnabled(false);
   button3.setEnabled(true);
  }
 }
 /**
  *     button3 (Pause).  .
  */
 void button3_actionPerformed(ActionEvent e)
 {
  if(jTable.getSelectedRow() > -1)
  {
   FilesCheckConnection fcc = (FilesCheckConnection)arrThread.elementAt(jTable.getSelectedRow());
   fcc.setStartThread(false); // 
   //   
   button2.setEnabled(true);
   button3.setEnabled(false);
  }
 }
 /**
  *     button4 (Delete).     .
  */
 void button4_actionPerformed(ActionEvent e)
 {
  FilesCheckConnection fcc = (FilesCheckConnection)arrThread.elementAt(jTable.getSelectedRow());
  fcc = null;
  arrThread.remove(jTable.getSelectedRow());
  TableModel tm = new DefaultTableModel(columnNames,arrThread.size());
  jTable.setModel(tm);
  updadeTable(); //  
 }
 /**
  *     button5 (View report File).
  *    .
  */
 void button5_actionPerformed(ActionEvent e)
 {
  JFrame jf = new JFrame("Report File");
  JScrollPane jScrollPane2 = new JScrollPane();
  jScrollPane2.getViewport().add(jTextArea1);
  jf.getContentPane().add(jScrollPane2);
  jf.setSize(640,480);
  jf.setVisible(true);
 }

 /**
 *           .
 */
 public synchronized void saveToReport(FilesCheckConnection fcc)
 {
  String msg = ""+fcc.getStartTime()+"   |   ";
  msg += fcc.getEndDate()+"   |   ";
  msg += fcc.getFileURL()+"   |   ";
  msg += ""+fcc.getSize()+"   |   ";
  msg += fcc.getStatusString()+"   |   ";
  msg += fcc.getError()+'\n';
  jTextArea1.append(msg);
  saveReportFile();
 }

 /**
 *   .
 */
 public synchronized  boolean saveReportFile()
 {
  try
  {
   // Open file
   File file = new File ("report.txt");
   // Create an output writer that will write to that file.
   // FileWriter handles international characters encoding conversions.
   FileWriter out = new FileWriter(file);
   String text = jTextArea1.getText();
   out.write(text);
   out.close();
   return true;
  }
  catch (IOException e)
  {
   statusBar.setText("Error saving report file.");
  }
  return false;
 }

 /**
 *     .
 */
 public void readReportFile()
 {
  try
  {
   // Open file.
   File file = new File("report.txt");
   // Get the size of the opened file.
   int size = (int)file.length();
   // Set to zero a counter for counting the number of
   // characters that have been read from the file.
   int chars_read = 0;
   // Create an input reader based on the file, so we can read its data.
   // FileReader handles international character encoding conversions.
   FileReader in = new FileReader(file);
  // Create a character array of the size of the file,
   // to use as a data buffer, into which we will read
   // the text data.
   char[] data = new char[size];
   // Read all available characters into the buffer.
   while(in.ready())
   {
    // Increment the count for each character read,
    // and accumulate them in the data buffer.
    chars_read += in.read(data, chars_read, size - chars_read);
   }
   in.close();
   // Create a temporary string containing the data,
   // and set the string into the JTextArea.
   jTextArea1.setText(new String(data, 0, chars_read));
  }
  catch (IOException e)
  {
   statusBar.setText("Error opening report file.");
  }
 }

 /**
 *    ,    .
 *     .
 */
 public synchronized void updadeTable()
 {
  int index=arrThread.size();
  for(int i = 0;i<index;i++)
  {
   FilesCheckConnection fcc = (FilesCheckConnection)arrThread.elementAt(i);
   updadeInfo(fcc);
  }
  //   
  DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer()
  {
   public void setValue(Object value)
   {
    if (value instanceof ColoredColumn)
    {
     ColoredColumn cc = (ColoredColumn) value;
     setBackground(cc.getBGColor());
     setForeground(cc.getFGColor());
     setText(cc.getText());
    }
    else
    {
     super.setValue(value);
    }
   }
  };
  TableColumn colorColumn = jTable.getColumn("Status");
  colorColumn.setCellRenderer(colorRenderer);
  jTable.getColumnModel().getColumn(0).setMaxWidth(80);
  jTable.getColumnModel().getColumn(0).setPreferredWidth(80);
  jTable.setEnabled(false);
  jTable.setSelectionMode(0);
 }

 /**
 *      .
 */
 public synchronized void updadeInfo(FilesCheckConnection fcc)
 {
  ColoredColumn cc = new ColoredColumn("No starting",Color.white,Color.black);
  if(fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING)cc = new ColoredColumn("Downloading",Color.white,Color.blue);
  else if(fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING_FINISH)cc = new ColoredColumn("Complete",Color.green,Color.black);
  else if(fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING_PAUSE)cc = new ColoredColumn("Pause",Color.yellow,Color.black);
  else if(fcc.getStatus() == FilesCheckConnection.STATUS_ERROR)cc = new ColoredColumn("Error",Color.red,Color.black);
  else if(fcc.getStatus() == FilesCheckConnection.STATUS_STARTING)cc = new ColoredColumn("Starting",Color.white,Color.green);
  int index=arrThread.indexOf(fcc);
  jTable.setValueAt(cc,index,0);
  jTable.setValueAt(fcc.getFileName(),index,1);
  jTable.setValueAt(""+fcc.getSize(),index,2);
  jTable.setValueAt(""+fcc.getCopmleted(),index,3);
  jTable.setValueAt(""+fcc.getPercent()+"%",index,4);
  jTable.setValueAt(fcc.getStartTime(),index,5);
  jTable.setValueAt(fcc.getEndDate(),index,6);
  jTable.setValueAt(fcc.getFileURL(),index,7);
 }
}