/*
 * Decompiled with CFR 0.152.
 */
package filescheck;

import filescheck.FilesCheck;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.swing.JLabel;

public class FilesCheckConnection
extends Thread {
    private FilesCheck filesCheck;
    public static int STATUS_ERROR = -1;
    public static int STATUS_NOSTARTED = 0;
    public static int STATUS_DOWLOADING = 1;
    public static int STATUS_DOWLOADING_FINISH = 2;
    public static int STATUS_DOWLOADING_PAUSE = 3;
    public static int STATUS_DELETED = 4;
    public static int STATUS_STARTING = 5;
    private String error = "";
    private int status = 0;
    private String fileName = "";
    private long size = 0L;
    private long completed = 0L;
    private byte percent = 0;
    private Date startTime;
    private Date endTime;
    private URL fileURL;
    private boolean startThread;
    private boolean stopThread;

    public FilesCheckConnection(FilesCheck filesCheck) {
        this.filesCheck = filesCheck;
    }

    public FilesCheckConnection(FilesCheck filesCheck, String fileURL) {
        this.filesCheck = filesCheck;
        try {
            this.fileURL = new URL(fileURL);
            JLabel jLabel = filesCheck.statusBar;
            synchronized (jLabel) {
                filesCheck.statusBar.setText("Adding URL successful");
                this.status = STATUS_STARTING;
            }
        }
        catch (Exception e) {
            JLabel jLabel = filesCheck.statusBar;
            synchronized (jLabel) {
                filesCheck.statusBar.setText("Error adding URL:".concat(String.valueOf(String.valueOf(e))));
            }
            this.status = STATUS_ERROR;
            this.error = "".concat(String.valueOf(String.valueOf(e)));
            filesCheck.updadeInfo(this);
        }
    }

    public void run() {
        if (this.fileURL != null) {
            this.filesCheck.updadeInfo(this);
            this.startThread = true;
            try {
                URLConnection connection = this.fileURL.openConnection();
                this.fileName = this.fileURL.getFile();
                this.size = connection.getContentLength();
                this.startTime = new Date();
                JLabel jLabel = this.filesCheck.statusBar;
                synchronized (jLabel) {
                    this.filesCheck.statusBar.setText("".concat(String.valueOf(String.valueOf(this.startTime.toString()))));
                }
                this.filesCheck.updadeInfo(this);
            }
            catch (Exception e) {
                this.status = STATUS_ERROR;
                this.error = "".concat(String.valueOf(String.valueOf(e)));
                this.filesCheck.saveToReport(this);
            }
            try {
                InputStream in = this.fileURL.openConnection().getInputStream();
                this.status = STATUS_DOWLOADING;
                int sizef = (int)this.size;
                boolean chars_read = false;
                byte[] data = new byte[sizef];
                this.filesCheck.updadeInfo(this);
                Date dd = new Date();
                long ccc = dd.getTime();
                while (this.completed != this.size) {
                    FilesCheckConnection filesCheckConnection = this;
                    synchronized (filesCheckConnection) {
                        while (!this.startThread) {
                            this.wait(100L);
                        }
                    }
                    data[(int)this.completed] = (byte)in.read();
                    ++this.completed;
                    this.percent = (byte)(this.completed / (this.size / (long)100));
                    if (ccc <= dd.getTime() + (long)1) continue;
                    ccc = dd.getTime();
                    this.filesCheck.updadeInfo(this);
                }
                in.close();
                this.endTime = new Date();
                this.status = STATUS_DOWLOADING_FINISH;
                this.filesCheck.updadeInfo(this);
                this.filesCheck.saveToReport(this);
            }
            catch (Exception e) {
                this.status = STATUS_ERROR;
                this.error = "".concat(String.valueOf(String.valueOf(e)));
                this.filesCheck.saveToReport(this);
            }
        }
        this.stopThread = true;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        switch (this.getStatus()) {
            case -1: {
                return "STATUS_ERROR";
            }
            case 0: {
                return "STATUS_NOSTARTED";
            }
            case 1: {
                return "STATUS_DOWLOADING";
            }
            case 2: {
                return "STATUS_DOWLOADING_FINISH";
            }
            case 3: {
                return "STATUS_DOWLOADING_PAUSE";
            }
            case 4: {
                return "STATUS_DELETED";
            }
            case 5: {
                return "STATUS_STARTING";
            }
        }
        return "STATUS_STARTING";
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSize() {
        return this.size;
    }

    public long getCopmleted() {
        return this.completed;
    }

    public byte getPercent() {
        return this.percent;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndDate() {
        return this.endTime;
    }

    public String getFileURL() {
        return this.fileURL.toExternalForm();
    }

    public String getError() {
        return this.error;
    }

    public void setStartThread(boolean start) {
        this.startThread = start;
        if (start) {
            this.status = STATUS_DOWLOADING;
            Thread.currentThread().setPriority(1);
        } else {
            this.status = STATUS_DOWLOADING_PAUSE;
            Thread.currentThread().setPriority(5);
        }
        this.filesCheck.updadeInfo(this);
    }

    public boolean isStartThread() {
        return this.startThread;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }
}

