/*
 * Decompiled with CFR 0.152.
 */
package filescheck;

import filescheck.ColoredColumn;
import filescheck.FilesCheckConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class FilesCheck
extends JFrame {
    Vector arrThread = new Vector();
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar toolBar = new JToolBar();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel statusBar = new JLabel(" No URL");
    String[] columnNames = new String[]{"Status", "File name", "Size", "Completed", "Percent", "Start Time", "End Time", "URL"};
    JTable jTable = new JTable(new DefaultTableModel(this.columnNames, 0));
    JTextArea jTextArea1 = new JTextArea();
    JTextField stringURL = new JTextField();
    JButton button1 = new JButton();
    JButton button2 = new JButton();
    JButton button3 = new JButton();
    JButton button4 = new JButton();
    JButton button5 = new JButton();

    public FilesCheck() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(640, 480));
        this.setTitle("FilesCheck");
        ImageIcon image1 = new ImageIcon(this.getToolkit().createImage("images/add.gif"));
        ImageIcon image2 = new ImageIcon(this.getToolkit().createImage("images/play.gif"));
        ImageIcon image3 = new ImageIcon(this.getToolkit().createImage("images/pause.gif"));
        ImageIcon image4 = new ImageIcon(this.getToolkit().createImage("images/delete.gif"));
        ImageIcon image5 = new ImageIcon(this.getToolkit().createImage("images/report.gif"));
        this.jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                FilesCheck.this.jTable_mouseClicked(e);
            }
        });
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilesCheck.this.button1_actionPerformed(e);
            }
        });
        this.button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilesCheck.this.button2_actionPerformed(e);
            }
        });
        this.button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilesCheck.this.button3_actionPerformed(e);
            }
        });
        this.button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilesCheck.this.button4_actionPerformed(e);
            }
        });
        this.button5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilesCheck.this.button5_actionPerformed(e);
            }
        });
        this.contentPane.add((Component)this.toolBar, "North");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setBackground(Color.white);
        this.button1.setIcon(image1);
        this.button1.setToolTipText("Add");
        this.button2.setIcon(image2);
        this.button2.setToolTipText("Start");
        this.button3.setIcon(image3);
        this.button3.setToolTipText("Pause");
        this.button4.setIcon(image4);
        this.button4.setToolTipText("Delete");
        this.button5.setIcon(image5);
        this.button5.setToolTipText("View report file");
        this.toolBar.add(this.stringURL);
        this.toolBar.add(this.button1);
        this.toolBar.add(this.button2);
        this.toolBar.add(this.button3);
        this.toolBar.add(this.button4);
        this.toolBar.add(this.button5);
        this.jTable.setSelectionMode(0);
        this.jTable.setEnabled(false);
        this.button2.setEnabled(false);
        this.button3.setEnabled(false);
        this.button4.setEnabled(false);
        this.jScrollPane1.getViewport().add(this.jTable);
        this.readReportFile();
    }

    protected void processWindowEvent(WindowEvent e) {
        block1: {
            super.processWindowEvent(e);
            if (e.getID() != 201) break block1;
            for (int i = 0; i < this.arrThread.size(); ++i) {
                FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(i);
                fcc = null;
            }
            System.exit(0);
        }
    }

    void jTable_mouseClicked(MouseEvent e) {
        this.jTable.addRowSelectionInterval(this.jTable.rowAtPoint(e.getPoint()), this.jTable.rowAtPoint(e.getPoint()));
        if (this.jTable.getSelectedRow() > -1) {
            this.button4.setEnabled(true);
            FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(this.jTable.getSelectedRow());
            if (fcc.isStopThread()) {
                this.button3.setEnabled(false);
                this.button3.setEnabled(false);
            } else if (fcc.isStartThread()) {
                this.button2.setEnabled(false);
                this.button3.setEnabled(true);
            } else {
                this.button2.setEnabled(true);
                this.button3.setEnabled(false);
            }
        }
    }

    void button1_actionPerformed(ActionEvent e) {
        try {
            DefaultTableModel tm = new DefaultTableModel(this.columnNames, this.arrThread.size() + 1);
            this.jTable.setModel(tm);
            FilesCheckConnection fcc = new FilesCheckConnection(this, this.stringURL.getText());
            this.arrThread.add(fcc);
            fcc.start();
            this.updadeTable();
        }
        catch (Exception ee) {
            System.out.println("Error: ".concat(String.valueOf(String.valueOf(ee))));
        }
    }

    void button2_actionPerformed(ActionEvent e) {
        if (this.jTable.getSelectedRow() > -1) {
            FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(this.jTable.getSelectedRow());
            fcc.setStartThread(true);
            this.button2.setEnabled(false);
            this.button3.setEnabled(true);
        }
    }

    void button3_actionPerformed(ActionEvent e) {
        if (this.jTable.getSelectedRow() > -1) {
            FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(this.jTable.getSelectedRow());
            fcc.setStartThread(false);
            this.button2.setEnabled(true);
            this.button3.setEnabled(false);
        }
    }

    void button4_actionPerformed(ActionEvent e) {
        FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(this.jTable.getSelectedRow());
        fcc = null;
        this.arrThread.remove(this.jTable.getSelectedRow());
        DefaultTableModel tm = new DefaultTableModel(this.columnNames, this.arrThread.size());
        this.jTable.setModel(tm);
        this.updadeTable();
    }

    void button5_actionPerformed(ActionEvent e) {
        JFrame jf = new JFrame("Report File");
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.jTextArea1);
        jf.getContentPane().add(jScrollPane2);
        ((Component)jf).setSize(640, 480);
        ((Component)jf).setVisible(true);
    }

    public synchronized void saveToReport(FilesCheckConnection fcc) {
        String msg = String.valueOf(String.valueOf(new StringBuffer("").append(fcc.getStartTime()).append("   |   ")));
        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fcc.getEndDate())).concat("   |   "))));
        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fcc.getFileURL())).concat("   |   "))));
        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("").append(fcc.getSize()).append("   |   "))))));
        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fcc.getStatusString())).concat("   |   "))));
        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fcc.getError())).concat(String.valueOf(String.valueOf('\n'))))));
        this.jTextArea1.append(msg);
        this.saveReportFile();
    }

    public synchronized boolean saveReportFile() {
        try {
            File file = new File("report.txt");
            FileWriter out = new FileWriter(file);
            String text = this.jTextArea1.getText();
            out.write(text);
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.statusBar.setText("Error saving report file.");
            return false;
        }
    }

    public void readReportFile() {
        try {
            File file = new File("report.txt");
            int size = (int)file.length();
            int chars_read = 0;
            FileReader in = new FileReader(file);
            char[] data = new char[size];
            while (in.ready()) {
                chars_read += in.read(data, chars_read, size - chars_read);
            }
            in.close();
            this.jTextArea1.setText(new String(data, 0, chars_read));
        }
        catch (IOException e) {
            this.statusBar.setText("Error opening report file.");
        }
    }

    public synchronized void updadeTable() {
        int index = this.arrThread.size();
        for (int i = 0; i < index; ++i) {
            FilesCheckConnection fcc = (FilesCheckConnection)this.arrThread.elementAt(i);
            this.updadeInfo(fcc);
        }
        DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object value) {
                if (value instanceof ColoredColumn) {
                    ColoredColumn cc = (ColoredColumn)value;
                    this.setBackground(cc.getBGColor());
                    this.setForeground(cc.getFGColor());
                    this.setText(cc.getText());
                } else {
                    super.setValue(value);
                }
            }
        };
        TableColumn colorColumn = this.jTable.getColumn("Status");
        colorColumn.setCellRenderer(colorRenderer);
        this.jTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.jTable.setEnabled(false);
        this.jTable.setSelectionMode(0);
    }

    public synchronized void updadeInfo(FilesCheckConnection fcc) {
        ColoredColumn cc = new ColoredColumn("No starting", Color.white, Color.black);
        if (fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING) {
            cc = new ColoredColumn("Downloading", Color.white, Color.blue);
        } else if (fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING_FINISH) {
            cc = new ColoredColumn("Complete", Color.green, Color.black);
        } else if (fcc.getStatus() == FilesCheckConnection.STATUS_DOWLOADING_PAUSE) {
            cc = new ColoredColumn("Pause", Color.yellow, Color.black);
        } else if (fcc.getStatus() == FilesCheckConnection.STATUS_ERROR) {
            cc = new ColoredColumn("Error", Color.red, Color.black);
        } else if (fcc.getStatus() == FilesCheckConnection.STATUS_STARTING) {
            cc = new ColoredColumn("Starting", Color.white, Color.green);
        }
        int index = this.arrThread.indexOf(fcc);
        this.jTable.setValueAt(cc, index, 0);
        this.jTable.setValueAt(fcc.getFileName(), index, 1);
        this.jTable.setValueAt("".concat(String.valueOf(String.valueOf(fcc.getSize()))), index, 2);
        this.jTable.setValueAt("".concat(String.valueOf(String.valueOf(fcc.getCopmleted()))), index, 3);
        this.jTable.setValueAt(String.valueOf(String.valueOf(new StringBuffer("").append(fcc.getPercent()).append("%"))), index, 4);
        this.jTable.setValueAt(fcc.getStartTime(), index, 5);
        this.jTable.setValueAt(fcc.getEndDate(), index, 6);
        this.jTable.setValueAt(fcc.getFileURL(), index, 7);
    }
}

